<?php

	use App\Http\Middleware\Authenticate;
	use Illuminate\Support\Facades\Route;

	/*
	|--------------------------------------------------------------------------
	| Web Routes
	|--------------------------------------------------------------------------
	|
	| Here is where you can register web routes for your application. These
	| routes are loaded by the RouteServiceProvider within a group which
	| contains the "web" middleware group. Now create something great!
	|
	*/

	/*
	Route::get('/', function(){
		return view('welcome');
	});
	*/


	Auth::routes();

	Route::get('/', 'HomeController@index')->name('home');

	Route::middleware([Authenticate::class])->group(function(){

		Route::get('/eventKinds', 'EventKindController@list')->name('eventKindListing');
		Route::get('/eventKinds/change/{eventKind}', 'EventKindController@change');
		Route::post('/eventKinds/doChange/', 'EventKindController@doChange')->name('eventKindDoChange');
	});
