@extends('layouts.app')

@section('content')
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="card">
					<div class="card-header">{{ __('Dashboard') }}</div>
					<div class="row">
						@foreach($events as $event)
							<div class="col-md-6">
								<div class="row">
									<div class="col-md-4">
										Id:
									</div>
									<div class="col-md-8">
										{{$event['id']}}
									</div>
									<div class="col-md-4">
										Name:
									</div>
									<div class="col-md-8">
										{!! $event['name'] !!}
									</div>
									<div class="col-md-4">
										Art:
									</div>
									<div class="col-md-8">
										<span title="{{$event['kind']['description']}}">
											{{$event['kind']['name']}}
										</span>
									</div>
									@if($event['organisation'] !== '')
										<div class="col-md-4">
											Organisation
										</div>
										<div class="col-md-8">
											{!! $event['organisation'] !!}
										</div>
									@endif
									@foreach($event['eventDates'] as $eventDate)
										<div class="col-md-4">
											Datum
										</div>
										<div class="col-md-8">
											{{ $eventDate['date'] }}
										</div>
										<div class="col-md-4">
											Uhrzeit
										</div>
										<div class="col-md-8">
											@if($eventDate['whole_day'] == 1)
												Von {{$eventDate['start']}}
											@else
												{{$eventDate['start']}} - {{$eventDate['end']}}
											@endif
										</div>
									@endforeach
								</div>
								<hr/>
							</div>
						@endforeach
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
