@extends('layouts.app')

@section('content')
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-md-8">
				<div class="card">
					<div class="card-header">Veranstaltungsarten</div>
					@foreach($eventKinds as $eventKind)
						<div class="row">
							<div class="col-md-2">
								<a href="/eventKinds/change/{{$eventKind->id}}">change</a>
							</div>
							<div class="col-md-10">
								{{$eventKind->name}}
							</div>
						</div>
					@endforeach
					<hr>
					<div class="row">
						<div class="col-md-4" style="text-align: right;">
							@if($eventKinds->currentPage() > 1)
								<a href="{{$eventKinds->previousPageUrl()}}">prev</a>
							@endif
						</div>
						<div class="col-md-4" style="text-align: center;">
							Seite: {{$eventKinds->currentPage()}} von {{$eventKinds->lastPage()}}
						</div>
						<div class="col-md-4">
							@if($eventKinds->currentPage() < $eventKinds->lastPage())
								<a href="{{$eventKinds->nextPageUrl()}}">next</a>
							@endif
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
@endsection
