<?php

	use App\Route as RouteModel;
	use Illuminate\Database\Seeder;
	use Illuminate\Support\Facades\Route;

	class RouteSeeder extends Seeder{
		/**
		 * Run the database seeds.
		 *
		 * @return void
		 */
		public function run(){
			$apiRoutes = array_filter(Route::getRoutes()->get(), function($route){
				return isset($route->action['middleware'][0])
					&&
					$route->action['middleware'][0] === 'api';
			});
			$ids = [];
			foreach($apiRoutes as $route){
				$model = RouteModel::firstOrCreate([
					'uri' => $route->uri,
					'method' => $route->methods[0],
				]);

				if(isset($route->action['as']) && $route->action['as']){
					if($route->action['as'] !== $model->name){
						$model->name = $route->action['as'];
						$model->save();
					}
				}

				$ids[] = $model->id;
			}
			RouteModel::whereNotIn('id', $ids)
				->delete();

		}
	}
