<?php

	use App\Route;
	use Illuminate\Database\Seeder;

	class RouteGroupRouteSeeder extends Seeder{
		/**
		 * Run the database seeds.
		 *
		 * @return void
		 */
		public function run(){
			/*
			 * RouteGroups:
			 * 1 - LRA
			 * 2 - Gemeinde
			 * 3 - Frontend
			 */

			$frontend = [
				'api/eventkind__GET',
				'api/eventkind/{eventKind}__GET',
				'api/eventDate__GET',
				'api/eventDate/{eventDate}__GET',
				'api/eventYears__GET',
				'api/location__GET',
				'api/location/{location}__GET',
			];

			$gemeinde = [
				'api/menu__GET',

				'api/media__GET',
				'api/media/{media}__GET',
				'api/media/{media}__DELETE',
				'api/mediaCreator/{media}__GET',
				'api/mediaUsage/{media}__GET',

				'api/location__GET',
				'api/location/{location}__GET',
				'api/location/{location}__PUT',
				'api/location__POST',
				'api/location/{location}__DELETE',
				'api/user/login__POST',
				'api/eventkind__GET',
				'api/eventkind/{eventKind}__GET',
				'api/myEvents__GET',
				'api/myEvents/{event}__DELETE',

				'api/myRecommendations__GET',
				'api/recommendationSeen__POST',
				'api/recommendationUnseen__POST',

				//'api/event__GET',
				'api/event/{event}__GET',
				'api/event__POST',
				'api/event/{event}__PUT',
				'api/event/{event}__DELETE',
				'api/eventMedia/{event}__PUT',

				'api/apiUser__GET',
				'api/apiUser/{apiUser}__GET',
				'api/apiUser__POST',
				'api/apiUser/{apiUser}__PUT',
				'api/apiUser/{apiUser}__DELETE',

				'api/user__GET',
				'api/user/{user}__GET',
				'api/user__POST',
				'api/user/{user}__PUT',
				'api/user/{user}__DELETE',

				'api/usergroup__GET',
				'api/usergroup/{userGroup}__GET',

				'api/eventReleases__GET',
				'api/recommendation__GET',
				'api/sendRecommendation__POST',

				'api/toggleRelease/{event}__POST',

				'api/groupLocations__GET',
				'api/userGroupLocations__GET',
				'api/userGroupLocations/{location}__GET',

				'api/downloadAsXML__GET',
				'api/downloadAsCSV__GET',
			];

			$lra = [
				'api/menu__GET',

				'api/media__GET',

				'api/location__GET',
				'api/location/{location}__GET',
				'api/location/{location}__PUT',
				'api/location__POST',
				'api/location/{location}__DELETE',

				'api/user/login__POST',

				'api/eventkind__GET',
				'api/eventkind/{eventKind}__GET',
				'api/eventkind__POST',
				'api/eventkind/{eventKind}__PUT',
				'api/eventkind/{eventKind}__DELETE',

				'api/event__GET',
				'api/myEvents__GET',
				'api/myEvents/{event}__DELETE',

				'api/myRecommendations__GET',
				'api/recommendationSeen__POST',
				'api/recommendationUnseen__POST',

				'api/event/{event}__GET',
				'api/event__POST',
				'api/event/{event}__PUT',
				'api/event/{event}__DELETE',
				'api/eventMedia/{event}__PUT',

				'api/usergroup__GET',
				'api/usergroup/{userGroup}__GET',
				'api/usergroup__POST',
				'api/usergroup/{userGroup}__PUT',
				'api/usergroup/{userGroup}__DELETE',

				'api/lraApiUser__GET',
				'api/lraApiUser/{apiUser}__GET',
				'api/lraApiUser__POST',
				'api/lraApiUser/{apiUser}__PUT',
				'api/lraApiUser/{apiUser}__DELETE',

				'api/lraUser__GET',
				'api/lraUser/{user}__GET',
				'api/lraUser__POST',
				'api/lraUser/{user}__PUT',
				'api/lraUser/{user}__DELETE',

				'api/usergroup__GET',
				'api/usergroup/{userGroup}__GET',
				'api/usergroup__POST',
				'api/usergroup/{userGroup}__PUT',
				'api/usergroup/{userGroup}__DELETE',

				'api/userGroupAuthority__GET',
				'api/userGroupAuthority/{authority}__GET',
				'api/userGroupAuthority/{authority}__PUT',
				'api/userGroupAuthority__POST',
				'api/userGroupAuthority/{authority}__DELETE',

				'api/eventReleases__GET',
				'api/recommendation__GET',
				'api/sendRecommendation__POST',

				'api/eventReleasesList__GET',
				'api/toggleRelease/{event}__POST',

				'api/groupLocations__GET',
				'api/userGroupLocations__GET',
				'api/userGroupLocations/{location}__GET',

				'api/downloadAsXML__GET',
				'api/downloadAsCSV__GET',

				'api/media__GET',
				'api/media/{media}__GET',
				'api/media/{media}__DELETE',
				'api/mediaCreator/{media}__GET',
				'api/mediaUsage/{media}__GET',
			];

			foreach($frontend as $route){
				$tmp = explode('__', $route);

				$route = Route::where([
					['uri', '=', $tmp[0]],
					['method', '=', $tmp[1]],
				])->get()->first();

				try{
					\App\RouteGroupRoute::firstOrCreate([
						'route' => $route->id,
						'route_group' => 3,
					]);
				}catch(\Throwable $e){
					print_r("error\n");
					dd($tmp);
				}
			}

			foreach($gemeinde as $route_string){
				$tmp = explode('__', $route_string);

				$route = Route::where([
					['uri', '=', $tmp[0]],
					['method', '=', $tmp[1]],
				])->get()->first();

				try{
					\App\RouteGroupRoute::firstOrCreate([
						'route' => $route->id,
						'route_group' => 2,
					]);
				}catch(\Exception $e){
					dd($tmp);
				}
			}

			foreach($lra as $route){
				$tmp = explode('__', $route);

				$route = Route::where([
					['uri', '=', $tmp[0]],
					['method', '=', $tmp[1]],
				])->get()->first();

				try{
					\App\RouteGroupRoute::firstOrCreate([
						'route' => $route->id,
						'route_group' => 1,
					]);
				}catch(\Exception $e){
					dd($tmp);
				}
			}
		}
	}
