<?php

	use Illuminate\Database\Seeder;
	use Illuminate\Support\Facades\Schema;

	class MenuSeeder extends Seeder{
		/**
		 * Run the database seeds.
		 *
		 * @return void
		 */
		public function run(){
			Schema::disableForeignKeyConstraints();
			\App\MenuRouteGroup::truncate();
			\App\Menu::truncate();
			Schema::enableForeignKeyConstraints();

			$menuRoutes = \App\Route::where([
				['method', '=', 'GET'],
				['uri', 'not like', '%{%}%'],
			])->get()->all();

			foreach($menuRoutes as $key => $route){
				$name = explode('/', $route->uri);
				if(count($name) !== 2 || !$route->name){
					continue;
				}
				list($name, $component, $position) = explode('__', $route->name);

				$menu = \App\Menu::create([
					'name' => $name,
					'component' => $component,
					'position' => $position,
				]);

				$routeGroupRoutes = \App\RouteGroupRoute::where('route', '=', $route->id)->get()->all();
				foreach($routeGroupRoutes as $routeGroupRoute){
					switch($route->uri){
						case 'api/eventkind':
						case 'api/location':
						case 'api/event':
							if($routeGroupRoute->route_group !== 1){
								continue 2;
							}
						break;
					}
					\App\MenuRouteGroup::create([
						'route_group' => $routeGroupRoute->route_group,
						'menu' => $menu->id,
					]);
				}

			}
		}
	}
