<?php

	use Illuminate\Database\Seeder;
	use Grimzy\LaravelMysqlSpatial\Types\Point;

	class LocationFix extends Seeder{
		/**
		 * Run the database seeds.
		 *
		 * @return void
		 */
		public function run(){
			$locations = \App\Location::select('*')
				->get()
				->all();

			foreach($locations as $loc){
				if($loc->gps){
					$lat = $loc->gps->getLat();
					$lng = $loc->gps->getLng();

					if($lat < $lng){
						$loc->gps = new Point($lng, $lat);

						$loc->update();
					}

				}
			}
		}
	}
