<?php

use Illuminate\Database\Seeder;

class GroupLocationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $userGroup = \App\UserGroup::find(1);

		\App\GroupLocation::deleteLocations($userGroup);

		$locations = \App\Location::select()
			->orderBy('name', 'asc')
			->get()
			->all();

		foreach($locations as $loc){
			\App\GroupLocation::create([
				'user_group' => $userGroup->id,
				'location' => $loc->id,
			]);
		}
    }
}
