<?php

	use Illuminate\Database\Migrations\Migration;
	use Illuminate\Database\Schema\Blueprint;
	use Illuminate\Support\Facades\Schema;

	class EventToUserGroup extends Migration{

		const TABLE_NAME = 'event_releases';

		/**
		 * Run the migrations.
		 *
		 * @return void
		 */
		public function up(){
			Schema::create(self::TABLE_NAME, function(Blueprint $table){
				$table->id();
				$table->foreignId('event');
				$table->foreignId('user_group');
				$table->boolean('released')->index();
				$table->timestamps();
				$table->softDeletes('deleted_at', 0);

				$table->foreign('event')->references('id')->on('events');
				$table->foreign('user_group')->references('id')->on('user_groups');
			});
		}

		/**
		 * Reverse the migrations.
		 *
		 * @return void
		 */
		public function down(){
			Schema::dropIfExists(self::TABLE_NAME);
		}
	}
