<?php

	use Illuminate\Database\Migrations\Migration;
	use Illuminate\Database\Schema\Blueprint;
	use Illuminate\Support\Facades\Schema;

	class ExtendEventTable extends Migration{
		/**
		 * Run the migrations.
		 *
		 * @return void
		 */
		public function up(){
			Schema::table('events', function(Blueprint $table){
				$table->string('organisation', 255)->nullable()->after('status');
				$table->string('web', 255)->nullable()->after('organisation');
				$table->string('mail', 255)->nullable()->after('web');
				$table->string('phone', 255)->nullable()->after('mail');
				$table->boolean('registration')->default(0)->after('phone');
				$table->text('price')->nullable()->after('registration');
				$table->boolean('free')->default(0)->after('price');
			});
			Schema::table('event_dates', function(Blueprint $table){
				$table->string('short_description', 500)->after('description');
			});
		}

		/**
		 * Reverse the migrations.
		 *
		 * @return void
		 */
		public function down(){
			Schema::table('events', function(Blueprint $table){
				$table->dropColumn('organisation');
				$table->dropColumn('web');
				$table->dropColumn('mail');
				$table->dropColumn('phone');
				$table->dropColumn('registration');
				$table->dropColumn('price');
				$table->dropColumn('free');
			});
			Schema::table('event_dates', function(Blueprint $table){
				$table->dropColumn('short_description')->after('description');
			});
		}
	}
