<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEventsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('name', 255)->index();
            $table->foreignId('kind')->index();
            $table->enum('status', [1,2,3,4,5,6])->index();
            $table->timestamps();
            $table->softDeletes('deleted_at', 0);
            //foreign ids
            $table->foreign('kind')->references('id')->on('event_kinds');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('events');
    }
}
