<?php

	namespace App;

	use Illuminate\Database\Eloquent\Model;

	class UserGroupAuthority extends Model{
		protected $fillable = [
			'user_group_main',
			'user_group_child',
		];

		protected $table = 'user_group_authorities';

		public static function getAllSubs($group, $includeSelf = false){
			$groups = self::select('user_group_child')
				->where('user_group_main', '=', $group)
				->get()
				->toArray();

			$res = array_map(function($res){
				return $res['user_group_child'];
			}, $groups);

			if($includeSelf){
				$res[] = $group;
			}

			return $res;
		}
	}
