<?php

	namespace App\Services\Validators;

	use App\Event;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class EventChecker{
		
		const EVENT_FIELDS = [
			'name' => 'Veranstaltungstitel fehlt',
			'kind' => 'Veranstaltungsart nicht ausgewählt',
		];
		
		const EVENTDATE_FIELDS = [
			'date' => 'Kein Beginn angegeben',
			'location' => 'Kein Ort angegeben',
		];
		
		public function __construct(){

		}

		/**
		 * @param array $params
		 * @return array
		 */
		public function validateEvent(array $params){
			$result = [];
			
			foreach(self::EVENT_FIELDS as $key => $error){
				if(empty($params[$key])){
					$result[] = $error;
				}
			}
			
			
			return $result;
		}
		
		/**
		 * @param array $params
		 * @return array
		 */
		public function validateEventDate(array $params){
			$result = [];
			
			foreach(self::EVENTDATE_FIELDS as $key => $error){
				if(empty($params[$key])){
					$result[] = $error;
				}
			}
			
			return $result;
		}
		
	}
