<?php

	namespace App\Services\Validators;

	use App\Event;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class ApiUserChecker{
		
		const FIELDS = [
			'domain' => 'Backend URL fehlt',
		];
		
		protected $request;
		
		public function __construct(Request $request){
			$this->request = $request;
		}

		/**
		 * @param array $params
		 * @return array
		 */
		public function validate(array $params){
			$result = [];
			
			foreach(self::FIELDS as $key => $error){
				if(empty($params[$key])){
					$result[] = $error;
				}
			}
			
			if($this->request->currentApiUser->group_id === 1){
				if(empty($params['group_id'])){
					$result[] = 'Gruppe fehlt';
				}
			}
			return $result;
		}
		
	}
