<?php

	namespace App\Services\Thumbnail;

	class GeneratorFactory{
		public static function get(string $path): BaseGenerator{
			if(!is_file($path)){
				throw new \InvalidArgumentException('"'.$path.'" is not a file path');
			}

			$mime = mime_content_type($path);

			switch($mime){
				case 'image/png':
					return new PngGenerator();
					break;

				case 'image/jpeg':
					return new JpgGenerator();
					break;

				default:
					return new GenericGenerator();
			}
		}
	}
