<?php

	namespace App\Services\Thumbnail;

	abstract class BaseGenerator{
		/**
		 * @param string $file
		 * @param int $dpi
		 * @return string destination
		 */
		public function convert(string $file, int $dpi){
			$source = $this->getImageResource($file);
			$width = imagesx($source);
			$height = imagesy($source);

			$thumbnail = imagecreatetruecolor($width, $height);

			imagecopy($thumbnail, $source, 0, 0, 0, 0, $width, $height);

			imageresolution($thumbnail, $dpi);

			return $thumbnail;
		}

		/**
		 * @param string $dest
		 * @param $file
		 * @return bool
		 */
		abstract public function save(string $dest, $file): bool;

		abstract protected function getImageResource(string $file);
	}
