<?php

	namespace App\Services;

	class Thumbnail{

		/**
		 * @param string $path
		 * @param int $dpi
		 * @return string thumbnail path
		 */
		public function convert(string $path, int $dpi): string{
			try{
				$converter = Thumbnail\GeneratorFactory::get($path);

				$res = $converter->convert($path, $dpi);

				if($res){
					$fileInfo = new \SplFileInfo($path);

					$destPath = $fileInfo->getPath().'/thumbnail/';
					if(!is_dir($destPath)){
						mkdir($destPath);
					}

					$dest = $destPath . $fileInfo->getFilename();

					if($converter->save($dest, $res)){
						return $dest;
					}else{
						return '';
					}
				}else{
					return '';
				}

			} catch(\InvalidArgumentException $e){
				return '';
			}
		}

	}
