<?php

	namespace App\Services;

	use GuzzleHttp\Client;

	class GPSApiService{

		private $apiKey = 'RVVfMThiMjc2ZGRjNzUyNDQwYzg5MzIxZmVmY2QxZmE4ZDE6NjhiMmZhN2ItNzgyZC00ZTJkLWEyZTctYmYzNWJhYWFmOGMx';

		private $url = 'https://api.myptv.com/geocoding/v1/locations/by-text';

		public function getLocation($locationString): ?array{
			$client = new Client();

			try{
				$response = $client->get($this->url, [
					'query' => [
						'searchText' => $locationString,
						'apiKey' => $this->apiKey,
					],
				]);

				return $this->evaluateResponse($response);

			} catch(\Throwable $e){
				return null;
			}
		}

		protected function evaluateResponse($response): ?array{
			if($response->getStatusCode() !== 200){
				return null;
			}

			$data = json_decode($response->getBody()->getContents(), 1);

			if(empty($data['locations']) || !is_array($data['locations']) || count($data['locations']) === 0){
				return null;
			}
			$locations = $data['locations'];

			usort($locations, function($a, $b){
				return $b['quality']['totalScore'] - $a['quality']['totalScore'];
			});

			return [
				'lat' => $locations[0]['referencePosition']['latitude'],
				'lng' => $locations[0]['referencePosition']['longitude'],
			];
		}
	}
