<?php

	namespace App\Services;

	use \Illuminate\Database\Eloquent\Builder;

	class EventDate{

		public function mergeEventDateQueries(Builder $query, array $filters){
			$start = null;
			$after = null;

			foreach($filters as $value){
				if(in_array($value[1], ['>', '>='], true)){
					$start = $value;
				}else{
					$after = $value;
				}
			}

			if($start && !$after){
				$query->where(function($query) use ($start){
					$query->orWhere('event_dates.date', '>=', $start[2]);
					$query->orWhere(function($query) use($start){
						$query->where('event_dates.date', '<', $start[2]);
						$query->where('event_dates.date_end', '>=', $start[2]);
					});
				});
			}

			if(!$start && $after){
				$query->where(function($query) use ($after){
					$query->orWhere('event_dates.date', '<=', $after[2]);
					$query->orWhere('event_dates.date_end', '<=', $after[2]);
				});
			}

			if($start && $after){
				$query->where('event_dates.date', '<=', $after[2]);
				$query->where(function($query) use ($start, $after){
					$query->orWhere(function($query) use($start, $after){
						$query->where('event_dates.date', '>=', $start[2]);
						$query->where(function($query) use ($start, $after){
							$query->orWhere('event_dates.date_end', '>=', $start[2]);
							$query->orWhere('event_dates.date', '<=', $after[2]);
						});
					});
				});
			}
		}

	}
