<?php

	namespace App;

	trait MediaRelationTrait{

		/**
		 * @return string
		 */
		public static function getStorageFolder(){
			$folder = explode('\\', self::class);
			return array_pop($folder);
		}

		/**
		 * @param Media|int $media
		 * @return mixed
		 */
		public function detachMedia($media){
			if($media instanceof Media){
				$mediaId = $media->id;
			}else{
				$mediaId = $media;
			}

			return \DB::table('media_relations')
				->where([
					['media_id', '=', $mediaId],
					['foreign_id', '=', $this->id],
					['model', '=', self::class],
				])
				->delete();

		}

		/**
		 * @param Media|int $media
		 * @return mixed
		 */
		public function attachMedia($media){

			if($media instanceof Media){
				$id = $media->id;
			}else{
				$id = $media;
			}

			$where = [
				'media_id' => $id,
				'foreign_id' => $this->id,
				'model' => self::class,
			];
			return \DB::table('media_relations')
				->updateOrInsert($where, $where);
		}

		public function getMedia(){
			return Media::selectRaw('media.id, media.name, media.file_name, media.path, media.group')
				->join('media_relations', 'media.id', '=', 'media_relations.media_id')
				->where([
					['media_relations.model', '=', self::class],
					['media_relations.foreign_id', '=', $this->id],
				])->get();
		}

		public function detachAllMedia(){
			\DB::table('media_relations')
				->where([
					['foreign_id', '=', $this->id],
					['model', '=', self::class],
				])
				->delete();

			return true;
		}

	}
