<?php

	namespace App\Mail;

	use App\Event;
	use App\EventDate;
	use App\UserGroup;
	use Illuminate\Bus\Queueable;
	use Illuminate\Contracts\Queue\ShouldQueue;
	use Illuminate\Mail\Mailable;
	use Illuminate\Queue\SerializesModels;

	class EventRecommendation extends Mailable{
		use Queueable, SerializesModels;

		/**
		 * @var \App\Event
		 */
		public $event;

		/**
		 * @var UserGroup
		 */
		public $userGroup;
		/**
		 * @var array
		 */
		public $eventDates;

		/**
		 * Create a new message instance.
		 *
		 * @param \App\Event $event
		 * @param array $eventDates
		 * @param \App\UserGroup $userGroup
		 */
		public function __construct(Event $event, array $eventDates, UserGroup $userGroup){
			$this->event = $event;

			$this->eventDates = $eventDates;
			$this->userGroup = $userGroup;
		}

		/**
		 * Build the message.
		 *
		 * @return $this
		 */
		public function build(){

			return $this
				->subject('Veranstaltungsempfehlung')
				->view('mail.EventRecommendation');
		}
	}
