<?php

	namespace App;

	use Grimzy\LaravelMysqlSpatial\Eloquent\SpatialTrait;
	use Illuminate\Database\Eloquent\Model;

	class Location extends Model{
		use SpatialTrait;

		protected $fillable = ['name', 'gps', 'parent_id'];

		public static $filterable = ['name',];

		protected $spatialFields = [
			'gps',
		];

		public function eventDate(){
			return $this->hasMany('App\EventDate', 'location', 'id');
		}

		public function parent(){
			return $this->belongsTo('App\Location', 'parent_id')->with('parent');
		}

		public function children(){
			return $this->hasMany('App\Location', 'parent_id', 'id')->with('children');
		}

		public static function getAllChildren(array $locations){
			$locs = self::whereIn('parent_id', $locations)
				->get()
				->all();

			$result = [];
			foreach($locs as $loc){
				$result[] = $loc->id;
			}

			return $result;

		}
	}
