<?php

	namespace App\Http\Resources;

	use Illuminate\Http\Resources\Json\JsonResource;

	class Media extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$tmp = explode('.', $this->path);
			$last = array_pop($tmp);

			$kind = '';
			switch(strtolower($last)){
				case 'jpg':
				case 'jpeg':
				case 'png':
				case 'gif':
				case 'tif':
					$kind = 'image';
					break;
				case 'pdf':
					$kind = 'pdf';
			}

			return [
				'id' => $this->id,
				'name' => $this->file_name,
				'url' => $this->getUrl(),
				'kind' => $kind,
			];
		}
	}
