<?php

	namespace App\Http\Resources;

	use Illuminate\Http\Resources\Json\JsonResource;

	class LraUser extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$apiUser = \App\ApiUser::find($this->api_user);
			$group = \App\UserGroup::find($apiUser->group_id);

			return [
				'id' => $this->id,
				'name' => $this->name,
				'email' => $this->email,
				'password' => '',
				'group_id' => $apiUser->group_id,
				'domain' => $apiUser->domain,
				'group' => $group->name,
			];
		}
	}
