<?php

	namespace App\Http\Resources;

	use App\Http\Resources\EventKind as EventKindResource;
	use App\EventKind;
	use Illuminate\Http\Resources\Json\JsonResource;

	class EventWithoutDate extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$media = $this->getMedia();
			$images = Media::collection($media);
			$kind = new EventKindResource(EventKind::find($this->kind));
			$kind = $kind->toArray($request);

			if($images->count() === 0){
				$userGroup = \App\UserGroup::find($this->created_by);
				if(!empty($kind['fallbackImage']['id'])){
					$images = [$kind['fallbackImage']];
					$images[0]['kind'] = 'image';
				}else{
					$images = Media::collection($userGroup->getMedia());
				}
			}

			$eventId = $this->id;
			if(isset($this->event) && $this->event){
				$eventId = $this->event;
			}
			return [
				'id' => $eventId,
				'name' => $this->name,
				'kind' => $kind,
				'status' => $this->status,
				'organisation' => $this->organisation,
				'web' => $this->web,
				'mail' => $this->mail,
				'phone' => $this->phone,
				'registration' => (bool) $this->registration,
				'price' => $this->price,
				'ticket_presale' => $this->ticket_presale,
				'free' => (bool) $this->free,
				'media' => $images,

				'facebook' => $this->facebook,
				'twitter' => $this->twitter,
				'instagram' => $this->instagram,

				'sustainability' => (bool) $this->sustainability,
				'accessible' => (bool) $this->accessible,
				'family_friendly' => (bool) $this->family_friendly,
				'with_cost' => (bool) $this->with_cost,
			];
		}
	}
