<?php

	namespace App\Http\Resources;

	use Illuminate\Http\Resources\Json\JsonResource;

	class EventKind extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			$media = $this->getMedia()->first();

			if($media){
				$image = [
					'id' => $media->id,
					'url' => $media->getUrl(),
					'name' => $media->file_name,
				];
			}else{
				$image = null;
			}
			if($this->fallback_image){
				$fallback = \App\Media::find($this->fallback_image);

				$fallback = [
					'id' => $fallback->id,
					'url' => $fallback->getUrl(),
					'name' => $fallback->file_name,
				];
			}else{
				$fallback = null;
			}

			return [
				'id' => $this->id,
				'name' => $this->name,
				'description' => $this->description,
				'image' => $image,
				'fallbackImage' => $fallback,
			];
		}
	}
