<?php

	namespace App\Http\Resources;

	use App\Http\Resources\Location as LocationResource;
	use App\Location;
	use Illuminate\Http\Resources\Json\JsonResource;

	class EventDate extends JsonResource{
		/**
		 * Transform the resource into an array.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return array
		 */
		public function toArray($request){
			if($this->location){
				$location = new LocationResource(Location::where(['id' => $this->location])->first());
				$location = $location->toArray($request);
			}else{
				$location = null;
			}
			$start = $this->start;
			if($start){
				$start = explode(':', $start);
				$start = $start[0] . ':' . $start[1];
			}
			$end = $this->end;
			if($end){
				$end = explode(':', $end);
				$end = $end[0] . ':' . $end[1];
			}

			$gps = [
				'lat' => '',
				'lng' => '',
			];

			if($this->gps){
				$gps = [
					'lat' => $this->gps? $this->gps->getLat() : null,
					'lng' => $this->gps? $this->gps->getLng() : null,
				];
			}

			return array(
				'id' => $this->id,
				'event' => $this->event,
				'location' => $location,
				'gps' => $gps,
				'canceled' => $this->canceled ? 1 : 0,
				'title' => $this->title,
				'description' => $this->description,
				'short_description' => $this->short_description,
				'street' => $this->street,
				'street_nr' => $this->street_nr,
				'address_supplement' => $this->address_supplement,
				'date' => $this->date,
				'date_end' => $this->date_end,
				'start' => $start,
				'end' => $end,
				'whole_day' => $this->whole_day,
			);
		}
	}
