<?php

	namespace App\Http\Middleware;

	use Closure;

	class PageSize{

		protected $maxPageSize = 2000;

		/**
		 * Handle an incoming request.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param Closure $next
		 * @return mixed
		 */
		public function handle($request, Closure $next){
			$pageSize = (int) $request->input('pageSize', $this->maxPageSize);
			$pageSize = min($pageSize, $this->maxPageSize);
			if($pageSize <= 0){
				$pageSize = $this->maxPageSize;
			}

			$request->pageSize = $pageSize;

			return $next($request);
		}
	}
