<?php

	namespace App\Http;

	use App\Http\Middleware\CheckForMaintenanceMode;
	use App\Http\Middleware\LogResponse;
	use App\Http\Middleware\TrimStrings;
	use App\Http\Middleware\TrustProxies;
	use App\Http\Middleware\XContentHeader;
	use Fruitcake\Cors\HandleCors;
	use Illuminate\Foundation\Http\Kernel as HttpKernel;
	use Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull;
	use Illuminate\Foundation\Http\Middleware\ValidatePostSize;

	class Kernel extends HttpKernel{
		/**
		 * The application's global HTTP middleware stack.
		 *
		 * These middleware are run during every request to your application.
		 *
		 * @var array
		 */
		protected $middleware = [
			// \App\Http\Middleware\TrustHosts::class,
			\Fruitcake\Cors\HandleCors::class,
			TrustProxies::class,
			HandleCors::class,
			CheckForMaintenanceMode::class,
			ValidatePostSize::class,
			TrimStrings::class,
			ConvertEmptyStringsToNull::class,
			XContentHeader::class,
		];

		/**
		 * The application's route middleware groups.
		 *
		 * @var array
		 */
		protected $middlewareGroups = [
			'web' => [
				\App\Http\Middleware\EncryptCookies::class,
				\Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
				\Illuminate\Session\Middleware\StartSession::class,
				// \Illuminate\Session\Middleware\AuthenticateSession::class,
				\Illuminate\View\Middleware\ShareErrorsFromSession::class,
				\App\Http\Middleware\VerifyCsrfToken::class,
				\Illuminate\Routing\Middleware\SubstituteBindings::class,
			],

			'api' => [
				'throttle:1000,1',
				\Illuminate\Routing\Middleware\SubstituteBindings::class,
				LogResponse::class,
			],
		];

		/**
		 * The application's route middleware.
		 *
		 * These middleware may be assigned to groups or used individually.
		 *
		 * @var array
		 */
		protected $routeMiddleware = [
			'auth' => \App\Http\Middleware\Authenticate::class,
			'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
			'bindings' => \Illuminate\Routing\Middleware\SubstituteBindings::class,
			'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
			'can' => \Illuminate\Auth\Middleware\Authorize::class,
			'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
			'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
			'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
			'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
			'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
		];
	}
