<?php

	namespace App\Http\Controllers;

	use App\Event;
	use App\EventDate;
	use App\GroupLocation;
	use App\Http\Resources\Usergroup as UsergroupResource;
	use App\Mail\EventRecommendation;
	use App\Media;
	use App\Recommendation;
	use App\UserGroup;
	use App\Services\Validators\UserGroupChecker;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;
	use Illuminate\Support\Facades\Mail;

	class UserGroupController extends Controller{
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
		 */
		public function index(Request $request){
			$query = UserGroup::select(['id', 'name', 'email'])
				->orderBy('name');

			foreach($request->filter as $value){
				if(in_array($value[0], UserGroup::$filterable)){
					$query->where(...$value);
				}
			}

			$query = $query->paginate($request->pageSize)
				->appends(request()->query());

			return UsergroupResource::collection($query);
		}

		/**
		 * Store a newly created resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function store(Request $request, UserGroupChecker $userGroupValidator){
			$params = $request->all();

			$errors = $userGroupValidator->validate($params);
			if(count($errors) > 0){
				return response()->json(['errors' => $errors], 200);
			}

			$userGroup = UserGroup::create($params);


			$newMedia = null;
			if(isset($request->files) && $request->files->count() == 1){
				$files = $request->files->get('image');
				if(isset($files[0])){
					$newFile = new \Illuminate\Http\UploadedFile(
						$files[0]->getRealPath(),
						$files[0]->getClientOriginalName(),
						$files[0]->getClientMimeType()
					);

					$newMedia = Media::createFromFile($newFile, UserGroup::getStorageFolder(), $request);
				}
				//$newMedia = Media::createFromUpload($request, Usergroup::getStorageFolder());
			}else if(isset($params['image'])){
				$newMedia = Media::find($params['image']);
			}

			if($newMedia){
				$userGroup->attachMedia($newMedia);
			}

			if(isset($params['locations'])){
				if(!is_array($params['locations'])){
					$params['locations'] = json_decode($params['locations'], 1);
				}
				if(is_array($params['locations']) && count($params['locations'])){
					GroupLocation::updateGroupLocations($userGroup, $params['locations']);
				}
			}

			return response()->json($userGroup, 201);
		}

		/**
		 * Display the specified resource.
		 *
		 * @param \App\UserGroup $userGroup
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function show(UserGroup $userGroup){
			return response()->json(new UsergroupResource($userGroup), 200);
		}

		/**
		 * Update the specified resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param \App\UserGroup $userGroup
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function update(Request $request, UserGroup $userGroup){
			$params = $request->all();
			$userGroup->update($request->all());
			$newMedia = null;
			if(isset($request->files) && $request->files->count() == 1){
				$files = $request->files->get('image');
				if(isset($files[0])){
					$newFile = new \Illuminate\Http\UploadedFile(
						$files[0]->getRealPath(),
						$files[0]->getClientOriginalName(),
						$files[0]->getClientMimeType()
					);

					$newMedia = Media::createFromFile($newFile, UserGroup::getStorageFolder(), $request);
				}
				//$newMedia = Media::createFromUpload($request, UserGroup::getStorageFolder());
			}else if(isset($params['image'])){
				$newMedia = Media::find($params['image']);
			}
			if($newMedia){
				$userGroup->detachAllMedia();
				$userGroup->attachMedia($newMedia);
			}

			if(!empty($params['locations']) && is_string($params['locations'])){
				$params['locations'] = json_decode($params['locations'], 1);
			}

			if(isset($params['locations']) && count($params['locations'])){
				GroupLocation::updateGroupLocations($userGroup, $params['locations']);
			}else{
				GroupLocation::deleteLocations($userGroup);
			}

			return response()->json(new UsergroupResource($userGroup), 200);
		}

		/**
		 * Remove the specified resource from storage.
		 *
		 * @param \App\UserGroup $userGroup
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function destroy(UserGroup $userGroup){
			$userGroup->delete();

			return response()->json(null, 204);
		}

		public function recommendationIndex(Request $request){
			$query = UserGroup::query()
				->where('id', '!=', $request->currentApiUser->group_id)
				->orderBy('name', 'ASC');

			$query = $query->get();

			return response()->json(UsergroupResource::collection($query), 200);
		}

		public function recommendationSend(Request $request){
			$params = $request->all();
			$event = Event::find($params['event']);

			Recommendation::where('event', '=', $event->id)
				->delete();
			foreach($params['groups'] as $group){
				$userGroup = UserGroup::find($group);
				if($userGroup){
					$recommendation = Recommendation::firstOrNew([
						'event' => $event->id,
						'user_group' => $userGroup->id,
					]);
					if(!$recommendation->seen){
						$recommendation->seen = 0;
					}

					$recommendation->save();
				}

			}

			return response()->json(null, 204);
		}

	}
