<?php

	namespace App\Http\Controllers;

	use App\Media;
	use App\UserGroup;
	use App\UserGroupAuthority;
	use Illuminate\Http\JsonResponse;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class MediaController extends Controller{


		public function index(Request $request){
			$groups = UserGroupAuthority::getAllSubs($request->currentApiUser->group_id, true);
			$mediaQuery = Media::select();

			$mediaQuery->where([
				['group', '=', 'event'],
			]);

			$mediaQuery->whereIn('created_by', $groups);

			$allowedFilters = [
				'file_name',
			];
			foreach($request->filter as $value){
				if(in_array($value[0], $allowedFilters)){
					$mediaQuery->where(...$value);
				}
			}

			$mediaQuery->orderBy('created_at', 'desc');

			$mediaQuery = $mediaQuery->paginate($request->pageSize)
				->appends(request()->query());

			return \App\Http\Resources\Media::collection($mediaQuery);

		}

		public function store(Request $request){
			$params = $request->all();
			$params['created_by'] = $request->currentApiUser->group_id;
			$media = Media::create($params);

			return response()->json($media, 201);
		}

		public function show(Media $media){
			return response()->json($media, 200);
		}

		public function update(Request $request, Media $eventKind){

		}

		public function destroy(Media $media){
			$media->deleteRelations();
			$media->delete();

			return response()->json(null, 204);
		}

		public function creator(Media $media){
			$creator = UserGroup::find($media->created_by);

			return new \App\Http\Resources\Usergroup($creator);
		}

		public function mediaUsage(Media $media){
			return new JsonResponse($media->getRelations(),200);
		}
	}
