<?php

	namespace App\Http\Controllers;

	use App\GroupLocation;
	use App\Http\Resources\Location as LocationResource;
	use App\Location;
	use Illuminate\Http\Request;

	class GroupLocationController extends Controller{
		public function index(Request $request){
			$params = $request->all();

			$user_group = ((isset($params['userGroup']))? $params['userGroup'] : $request->currentApiUser->group_id);
			$locations = array_unique(GroupLocation::getLocations($user_group));

			$childLocations = array_unique(GroupLocation::getChildLocations($user_group));
			$forLocations = Location::select()
				->whereIn('id', $locations)
				->orderBy('name', 'asc')
				->get()
				->all();

			$forChildLocations = Location::select()
				->whereIn('id', $childLocations)
				->orderBy('name', 'asc')
				->get()
				->all();

			return response()->json([
				'own' => \App\Http\Resources\Location::collection($forLocations),
				'children' => \App\Http\Resources\Location::collection($forChildLocations),
			], 200);

		}

		public function userGroupLocations(Request $request){
			$user_group = $request->currentApiUser->group_id;
			$locations = array_unique(GroupLocation::getLocations($user_group));
			$childLocations = array_unique(GroupLocation::getChildLocations($user_group));

			$locations = array_unique(array_merge($locations, $childLocations));
			$query = Location::select()->with('children');

			$query->whereIn('id', $locations);

			foreach($request->filter as $value){
				if(in_array($value[0], Location::$filterable)){
					$query->where(...$value);
				}
			}

			$coll = LocationResource::collection($query->get());
			$ids = [];
			foreach($coll as $loc){
				$ids[] = $loc->id;
				if($loc->resource->children){
					foreach($loc->resource->children as $child){
						$ids[] = $child->id;
					}
				}
			}

			$ids = array_unique($ids);
			$query = Location::select()->with('children');
			$query->whereIn('id', $ids);


			$query->orderBy('locations.name', 'asc');
			if($request->pageSize){
				$query = $query->paginate($request->pageSize);
			}
			$query = $query->appends(request()->query());

			$coll = LocationResource::collection($query);
			return $coll;

		}
	}
