<?php

	namespace App\Http\Controllers;

	use App\Event;
	use App\Http\Resources\EventRelease;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class EventReleaseController extends Controller{

		public function index(Request $request){
			$params = $request->all();
			if(empty($params['groups'])){
				$params['groups'] = [
					$request->currentApiUser->group_id,
				];
			}else{
				$params['groups'] = json_decode($params['groups'], 1);
			}

			$group = $request->currentApiUser->group_id;

			if(isset($params['groups']) && is_array($params['groups']) && count($params['groups']) > 0){
				$group = $params['groups'][0];
			}
			$query = Event::selectRaw('events.id, events.name');
			$query->leftJoin('event_dates', 'events.id', '=', 'event_dates.event');
			$query->leftJoin('event_releases', 'events.id', '=', 'event_releases.event');

			$query->groupByRaw('events.id, events.name, event_dates.date');

			foreach($request->filter as $value){
				$query->where(...$value);
			}

			$query->orderBy('event_dates.date', 'desc');
			$query = $query->paginate($request->pageSize)
				->appends(request()->query());

			return EventRelease::collection($query);
		}

		public function toggle(Event $event, Request $request){
			DB::table('event_releases')
				->updateOrInsert([
					'event' => $event->id,
					'user_group' => $request->get('userGroup'),
				],
					[
						'released' => $request->get('released')? 1 : 0,
					]);

			return response()->json(null, 204);
		}

	}
