<?php

	namespace App\Http\Controllers;

	use App\EventKind;
	use App\Http\Resources\Event;
	use App\Http\Resources\EventKind as EventKindResource;
	use App\Media;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class EventKindController extends Controller{
		/**
		 * Display a listing of the resource.
		 *
		 * @param Request $request
		 * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
		 */
		public function index(Request $request){
			$query = EventKind::select();
			foreach($request->filter as $value){
				if(in_array($value[0], EventKind::$filterable)){
					$query->orWhere(...$value);
				}
			}

			$query->orderBy('event_kinds.name', 'ASC');

			$query = $query->paginate($request->pageSize)
				->appends(request()->query());
			return EventKindResource::collection($query);
		}

		/**
		 * Store a newly created resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function store(Request $request){
			$params = $request->all();
			$forCreate = [
				'name' => $params['name'],
				'description' => $params['description'],
			];

			if($request->files->has('fallback')){
				$fallbackImage = $request->files->get('fallback')[0];

				$newFile = new \Illuminate\Http\UploadedFile(
					$fallbackImage->getRealPath(),
					$fallbackImage->getClientOriginalName(),
					$fallbackImage->getClientMimeType()
				);
				$media = Media::createFromFile($newFile, 'eventKindFallback', $request);

				$forCreate['fallback_image'] = $media->id;
			}else if($params['fallback']){
				$forCreate['fallback_image'] = $params['fallback'];
			}

			$eventKind = EventKind::create($forCreate);

			$newMedia = null;
			if($request->files->has('image')){
				$img = $request->files->get('image')[0];

				$newFile = new \Illuminate\Http\UploadedFile(
					$img->getRealPath(),
					$img->getClientOriginalName(),
					$img->getClientMimeType()
				);
				$newMedia = Media::createFromFile($newFile, EventKind::getStorageFolder(), $request);
			}else if(isset($params['image'])){
				$newMedia = Media::find($params['image']);
			}

			if($newMedia){
				$eventKind->attachMedia($newMedia);
			}

			return response()->json(new EventKindResource($eventKind), 201);
		}

		/**
		 * Display the specified resource.
		 *
		 * @param EventKind $eventKind
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function show(EventKind $eventKind){
			return response()->json(new EventKindResource($eventKind), 200);
		}

		/**
		 * Update the specified resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param EventKind $eventKind
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function update(Request $request, EventKind $eventKind){
			$params = $request->all();

			$forUpdate = [
				'name' => $params['name'],
				'description' => $params['description'],
			];

			if($request->files->has('fallback')){
				$fallbackImage = $request->files->get('fallback')[0];

				$newFile = new \Illuminate\Http\UploadedFile(
					$fallbackImage->getRealPath(),
					$fallbackImage->getClientOriginalName(),
					$fallbackImage->getClientMimeType()
				);
				$media = Media::createFromFile($newFile, 'eventKindFallback', $request);

				$forUpdate['fallback_image'] = $media->id;
			}else if($params['fallback']){
				$forUpdate['fallback_image'] = $params['fallback'];
			}

			$eventKind->update($forUpdate);
			$newMedia = null;

			if($request->files->has('image')){
				$img = $request->files->get('image')[0];

				$newFile = new \Illuminate\Http\UploadedFile(
					$img->getRealPath(),
					$img->getClientOriginalName(),
					$img->getClientMimeType()
				);
				$newMedia = Media::createFromFile($newFile, EventKind::getStorageFolder(), $request);
			}else if(isset($params['image'])){
				$newMedia = Media::find($params['image']);
			}

			if($newMedia){
				$eventKind->detachAllMedia();
				$eventKind->attachMedia($newMedia);
			}

			return response()->json(new EventKindResource($eventKind), 200);
		}

		/**
		 * Remove the specified resource from storage.
		 *
		 * @param EventKind $eventKind
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function destroy(EventKind $eventKind){
			try{
				$eventKind->delete();

				return response()->json(null, 204);
			}catch(\Exception $e){
				return response()->json(['error' => 'Kann nicht gelöscht werden, da es noch in Benutzung ist'], 409);
			}
		}

	}
