<?php

	namespace App\Http\Controllers;

	use App\ApiUser;
	use App\Services\ApiKeyGenerator;
	use App\Services\Validators\ApiUserChecker;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class ApiUserController extends Controller{

		/**
		 * @var \App\Services\ApiKeyGenerator
		 */
		protected $apiKeyGenerator;

		public function __construct(ApiKeyGenerator $apiKeyGenerator){
			$this->apiKeyGenerator = $apiKeyGenerator;
		}

		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
		 */
		public function index(Request $request){
			$user_group = $request->currentApiUser->group_id;
			$forUserApiUsers = DB::table('users')
				->select('api_user')
				->where('api_user', '!=', null)
				->get()
				->all();
			$userApiUser = [];

			foreach($forUserApiUsers as $user){
				$userApiUser[] = $user->api_user;
			}


			$query = ApiUser::where('group_id', '=', $user_group)
				->whereNotIn('id', $userApiUser);

			foreach($request->filter as $value){
				if(in_array($value[0], ApiUser::$filterable)){
					$query->where(...$value);
				}
			}

			$query = $query->paginate($request->pageSize)
				->appends(request()->query());

			return \App\Http\Resources\ApiUser::collection($query);
		}

		/**
		 * Store a newly created resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param \App\Services\Validators\ApiUserChecker $apiUserValidator
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function store(Request $request, ApiUserChecker $apiUserValidator){
			$params = $request->json()->all();

			$errors = $apiUserValidator->validate($params);
			if(count($errors)>0){
				return response()->json(['errors' => $errors], 200);
			}

			$apiUser = ApiUser::create([
				'domain' => $params['domain'],
				'route_group' => 3,
				'key' => $this->apiKeyGenerator->generate(),
				'group_id' => $request->currentApiUser->group_id,
			]);

			return response()->json(new \App\Http\Resources\ApiUser($apiUser), 201);
		}

		/**
		 * Display the specified resource.
		 *
		 * @param ApiUser $apiUser
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function show(ApiUser $apiUser){
			return response()->json(new \App\Http\Resources\ApiUser($apiUser), 200);
		}

		/**
		 * Update the specified resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param ApiUser $apiUser
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function update(Request $request, ApiUser $apiUser, ApiUserChecker $apiUserValidator){
			$params = $request->all();

			$errors = $apiUserValidator->validate($params);
			if(count($errors)>0){
				return response()->json(['errors' => $errors], 200);
			}

			$apiUser->domain = $params['domain'];
			$apiUser->save();
			return response()->json(new \App\Http\Resources\ApiUser($apiUser), 200);
		}

		/**
		 * Remove the specified resource from storage.
		 *
		 * @param ApiUser $apiUser
		 * @return \Illuminate\Http\Response
		 */
		public function destroy(ApiUser $apiUser){
			$apiUser->delete();

			return response()->json(null, 204);
		}

		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection
		 */
		public function lraIndex(Request $request){
			$user_group = $request->currentApiUser->group_id;
			$forUserApiUsers = DB::table('users')
				->select('api_user')
				->where('api_user', '!=', null)
				->get()
				->all();
			$userApiUser = [];

			foreach($forUserApiUsers as $user){
				$userApiUser[] = $user->api_user;
			}

			$query = ApiUser::selectRaw('api_users.id, api_users.group_id, api_users.route_group, api_users.key, api_users.domain')
				->whereNotIn('api_users.id', $userApiUser);

			$query->join('user_groups', 'api_users.group_id', '=', 'user_groups.id');
			if(count($request->filter)){
				$query->where(function($query) use($request){
					foreach($request->filter as $value){
						if(in_array($value[0], ApiUser::$filterable)){
							$query->orWhere(...$value);
						}
					}
				});
			}

			$query->orderBy('domain', 'asc');
			$query = $query->paginate($request->pageSize)
				->appends(request()->query());

			return \App\Http\Resources\LraApiUser::collection($query);
		}

		/**
		 * Store a newly created resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function lraStore(Request $request, ApiUserChecker $apiUserValidator){
			$params = $request->json()->all();

			$errors = $apiUserValidator->validate($params);
			if(count($errors)>0){
				return response()->json(['errors' => $errors], 200);
			}

			$apiUser = ApiUser::create([
				'domain' => $params['domain'],
				'route_group' => 3,
				'key' => $this->apiKeyGenerator->generate(),
				'group_id' => $params['group_id'],
			]);

			return response()->json(new \App\Http\Resources\LraApiUser($apiUser), 201);
		}

		/**
		 * Display the specified resource.
		 *
		 * @param ApiUser $apiUser
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function lraShow(ApiUser $apiUser){
			return response()->json(new \App\Http\Resources\LraApiUser($apiUser), 200);
		}

		/**
		 * Update the specified resource in storage.
		 *
		 * @param \Illuminate\Http\Request $request
		 * @param ApiUser $apiUser
		 * @return \Illuminate\Http\JsonResponse
		 */
		public function lraUpdate(Request $request, ApiUser $apiUser, ApiUserChecker $apiUserValidator){
			$params = $request->all();

			$errors = $apiUserValidator->validate($params);
			if(count($errors)>0){
				return response()->json(['errors' => $errors], 200);
			}

			$apiUser->domain = $params['domain'];
			$apiUser->save();
			return response()->json(new \App\Http\Resources\LraApiUser($apiUser), 200);
		}

		/**
		 * Remove the specified resource from storage.
		 *
		 * @param ApiUser $apiUser
		 * @return \Illuminate\Http\Response
		 */
		public function lraDestroy(ApiUser $apiUser){
			$apiUser->delete();

			return response()->json(null, 204);
		}
	}
