<?php

	namespace App;

	use Illuminate\Database\Eloquent\Model;

	class GroupLocation extends Model{

		protected $fillable = ['user_group', 'location'];


		public static function getLocations($userGroup){
			$ids = [];

			$locations = self::select()
				->where('user_group', '=', $userGroup)
				->get()
				->all();

			foreach($locations as $location){
				$ids[] = $location->location;
			}

			return $ids;
		}

		public static function getChildLocations($userGroup, $ids = [], $groupsDone = []){
			$subGroups = UserGroupAuthority::select()
				->where('user_group_main', '=', $userGroup)
				->get()
				->all();
			foreach($subGroups as $subGroup){
				if(!in_array($subGroup->user_group_child, $groupsDone)){
					$locations = self::select()
						->where('user_group', '=', $subGroup->user_group_child)
						->get()
						->all();
					foreach($locations as $location){
						$ids[] = $location->location;
					}
					$groupsDone[] = $subGroup->user_group_child;
					$ids = self::getChildLocations($subGroup->user_group_child, $ids, $groupsDone);
				}
			}

			return $ids;
		}

		public static function deleteLocations(UserGroup $userGroup){
			self::where('user_group', '=', $userGroup->id)->delete();
		}

		public static function updateGroupLocations(UserGroup $userGroup, array $locations){
			self::deleteLocations($userGroup);
			foreach($locations as $location){
				$x = self::create([
					'user_group' => $userGroup->id,
					'location' => $location,
				]);
			}

			return true;
		}

	}
