<?php

	use App\Http\Middleware\ApiAuthentication;
	use App\Http\Middleware\BackendCheck;
	use App\Http\Middleware\Filter;
	use App\Http\Middleware\HandlePutFormData;
	use App\Http\Middleware\PageSize;
	use App\Location;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\Route;

	/*
	|--------------------------------------------------------------------------
	| API Routes
	|--------------------------------------------------------------------------
	|
	| Here is where you can register API routes for your application. These
	| routes are loaded by the RouteServiceProvider within a group which
	| is assigned the "api" middleware group. Enjoy building your API!
	|
	*/


	Route::post('/user/login', 'UserController@login');

	Route::get('/', function(){
		dd('hallo Welt');
		$events = \App\EventDate::select()
			->whereIn('event', [3, 8, 10, 11, 14, 18, 23, 25, 29])
			->get()
			->all();

		$exporter = new \App\Services\CSVEventExporter([
			'Event Id',
			'Eventname',
			'Namenszusatz',
			'Beschreibung',
			'Eventart',
			'Organisator',
			'Web',
			'Email',
			'Telefon',
			'Anmeldung',
			'Preis',
			'Kostenlos',
			'Facebook',
			'Twitter',
			'Instagram',
			'Nachhaltig',
			'Behindertengerecht',
			'Familienfreundlich',

			'Eventdatum Id',
			'Ort',
			'GPS',
			'Straße',
			'Hausnummer',
			'Adresszusatz',
			'Abgesagt',
			'Datum',
			'Datum Ende',
			'Uhrzeit Beginn',
			'Uhrzeit Ende',
			'Ganztags',


		], $events);

		$csv = $exporter->generateCsv();

		return response()->streamDownload(function() use ($csv){
			echo $csv;
		}, 'export.csv', [
			'Content-Type' => 'text/csv; charset=utf-8',
			'Content-Disposition' => 'attachment; filename="export.csv"',
		]);
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([Filter::class, PageSize::class])
			->get('/location', 'LocationController@index')
			->name('Orte__LocationIndex__6');
		Route::get('/location/{location}', 'LocationController@show')
			->name('Location Detail');
		Route::post('/location', 'LocationController@store')
			->name('Location create');
		Route::put('/location/{location}', 'LocationController@update')
			->name('Location update');
		Route::delete('/location/{location}', 'LocationController@destroy')
			->name('Location delete');
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([Filter::class, PageSize::class])
			->get('/region', 'RegionController@index');
		Route::get('/region/{region}', 'RegionController@show')
			->name('Region Detail');
		Route::post('/region', 'RegionController@store')
			->name('Region create');
		Route::put('/region/{region}', 'RegionController@update')
			->name('Region update');
		Route::delete('/region/{region}', 'RegionController@delete')
			->name('Region delete');
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([Filter::class, PageSize::class])
			->get('/usergroup', 'UserGroupController@index')
			->name('Gruppen__UsergroupIndex__9');
		Route::get('/usergroup/{userGroup}', 'UserGroupController@show');
		Route::middleware([HandlePutFormData::class])->post('/usergroup', 'UserGroupController@store');
		Route::middleware([HandlePutFormData::class])->put('/usergroup/{userGroup}', 'UserGroupController@update');
		Route::delete('/usergroup/{userGroup}', 'UserGroupController@destroy');
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([Filter::class, PageSize::class])
			->get('/eventkind', 'EventKindController@index')
			->name('Veranstaltungsarten__EventKindsIndex__5');
		Route::get('/eventkind/{eventKind}', 'EventKindController@show');
		Route::middleware([BackendCheck::class])->group(function(){
			Route::middleware([HandlePutFormData::class])->post('/eventkind', 'EventKindController@store');
			Route::middleware([HandlePutFormData::class])
				->put('/eventkind/{eventKind}', 'EventKindController@update');
			Route::delete('/eventkind/{eventKind}', 'EventKindController@destroy');
		});
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([Filter::class, PageSize::class])->get('/media', 'MediaController@index')
			->name('Media__MediaIndex__11');
		Route::get('/media/{media}', 'MediaController@show');
		Route::post('/media', 'MediaController@store');
		Route::put('/media/{media}', 'MediaController@update');
		Route::delete('/media/{media}', 'MediaController@destroy');

		Route::get('/mediaCreator/{media}', 'MediaController@creator');
		Route::get('/mediaUsage/{media}', 'MediaController@mediaUsage');

	});



	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([Filter::class, PageSize::class])
			->get('/event', 'EventController@index')
			->name('Alle Veranstaltungen__EventsIndex__3');


		Route::middleware([Filter::class, PageSize::class])
			->get('/myEvents', 'EventController@myEvents')
			->name('Meine Veranstaltungen__MyEvents__1');

		Route::delete('/myEvents/{event}', 'EventController@destroy');


		Route::middleware([Filter::class, PageSize::class])
			->get('/myRecommendations', 'EventController@myRecommendations')
			->name('Mir empfohlen__MyRecommendations__2');

		Route::post('/recommendationSeen', 'EventController@recommendationSeen');
		Route::post('/recommendationUnseen', 'EventController@recommendationUnseen');


		Route::get('/event/{event}', 'EventController@show');
		Route::middleware([HandlePutFormData::class])->post('/event', 'EventController@store');
		Route::middleware([HandlePutFormData::class])->put('/event/{event}', 'EventController@update');
		Route::delete('/event/{event}', 'EventController@destroy');

		Route::middleware([HandlePutFormData::class])
			->put('/eventMedia/{event}', 'EventController@updateMedia');
	});


	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([PageSize::class, Filter::class])
			->get('/eventDate', 'EventDateController@index');
		Route::get('/eventDate/{eventDate}', 'EventDateController@show');
		Route::get('/eventYears', 'EventDateController@getYears');
	});

	Route::middleware([ApiAuthentication::class])->get('/menu', 'MenuController@index');


	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([PageSize::class, Filter::class])
			->get('/apiUser', 'ApiUserController@index')
			->name('Api Benutzer__ApiUserIndex__5');
		Route::get('/apiUser/{apiUser}', 'ApiUserController@show');
		Route::post('/apiUser', 'ApiUserController@store');
		Route::put('/apiUser/{apiUser}', 'ApiUserController@update');
		Route::delete('/apiUser/{apiUser}', 'ApiUserController@destroy');
	});


	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([PageSize::class, Filter::class])
			->get('/user', 'UserController@index')
			->name('Benutzer__UserIndex__4');
		Route::get('/user/{user}', 'UserController@show');
		Route::post('/user', 'UserController@store');
		Route::put('/user/{user}', 'UserController@update');
		Route::delete('/user/{user}', 'UserController@destroy');
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([PageSize::class, Filter::class])
			->get('/lraApiUser', 'ApiUserController@lraIndex')
			->name('Api Benutzer__LraApiUserIndex__8');
		Route::get('/lraApiUser/{apiUser}', 'ApiUserController@lraShow');
		Route::post('/lraApiUser', 'ApiUserController@lrastore');
		Route::put('/lraApiUser/{apiUser}', 'ApiUserController@lraupdate');
		Route::delete('/lraApiUser/{apiUser}', 'ApiUserController@lraDestroy');
	});


	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([PageSize::class, Filter::class])
			->get('/lraUser', 'UserController@lraIndex')
			->name('Benutzer__LraUserIndex__7');
		Route::get('/lraUser/{user}', 'UserController@lraShow');
		Route::post('/lraUser', 'UserController@lraStore');
		Route::put('/lraUser/{user}', 'UserController@lraUpdate');
		Route::delete('/lraUser/{user}', 'UserController@lraDestroy');
	});


	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([PageSize::class, Filter::class])
			->get('userGroupAuthority', 'UserGroupAuthorityController@index')
			->name('Gruppengruppierung__UserGroupAuthorityIndex__10');
		Route::get('/userGroupAuthority/{authority}', 'UserGroupAuthorityController@show');
		Route::put('/userGroupAuthority/{authority}', 'UserGroupAuthorityController@update');
		Route::post('/userGroupAuthority', 'UserGroupAuthorityController@store');
		Route::delete('/userGroupAuthority/{authority}', 'UserGroupAuthorityController@destroy');
		Route::get('/eventReleases/', 'EventController@releases');
	});


	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::get('recommendation', 'UserGroupController@recommendationIndex');
		Route::post('sendRecommendation', 'UserGroupController@recommendationSend');
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([PageSize::class, Filter::class])
			->get('eventReleasesList', 'EventReleaseController@index');
		//->name('Veranstaltungsfreigaben__EventReleaseIndex__4');

		Route::post('toggleRelease/{event}', 'EventReleaseController@toggle');
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::get('groupLocations', 'GroupLocationController@index');

		Route::middleware([PageSize::class, Filter::class])->get('userGroupLocations', 'GroupLocationController@userGroupLocations');
		Route::get('userGroupLocations/{location}', function(\App\Location $location){
			return response()->json($location, 200);
		});
	});

	Route::middleware([ApiAuthentication::class])->group(function(){
		Route::middleware([Filter::class])->get('downloadAsXML', 'EventDateController@downloadAsXML');
		Route::middleware([Filter::class])->get('downloadAsCSV', 'EventDateController@downloadAsCsv');

	});

	Route::get('locationGPS', 'EventDateController@locationGPS');
