<?php

    use App\Event;
    use App\EventKind;
    use Faker\Factory;
    use Illuminate\Database\Seeder;
    use Illuminate\Support\Facades\Schema;

class EventTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Schema::disableForeignKeyConstraints();
        Event::truncate();

        $faker = Factory::create();

        for($i=0;$i<500;$i++){
            Event::create([
                'name' => $faker->text(20),
                'kind' => EventKind::inRandomOrder()->limit(1)->get()->first()->id,
                'status' => $faker->randomElement([1,2,3,4,5,6]),
            ]);
        }

        Schema::enableForeignKeyConstraints();

        $this->call([
            EventDateTableSeeder::class,
        ]);
    }
}
