<?php

	use App\EventKind;
	use Faker\Factory;
	use Illuminate\Database\Seeder;

	class EventKindTableSeeder extends Seeder{
		/**
		 * Run the database seeds.
		 *
		 * @return void
		 */
		public function run(){
			DB::statement('SET FOREIGN_KEY_CHECKS=0;');
			EventKind::truncate();
			DB::statement('SET FOREIGN_KEY_CHECKS=1;');

			$faker = Factory::create();

			for($i = 0; $i < 500; $i++){
				$x = EventKind::create([
					'name' => $faker->text(20),
					'description' => $faker->text(750),
				]);

				$x->attachMedia(\App\Media::inRandomOrder()->limit(1)->get()->first());
			}

			$this->call([
				EventTableSeeder::class,
			]);

		}
	}
