<?php

	use App\Event;
	use App\EventDate;
	use App\Location;
	use Illuminate\Support\Facades\Schema;
	use Faker\Factory;
	use Illuminate\Database\Seeder;

	class EventDateTableSeeder extends Seeder{
		/**
		 * Run the database seeds.
		 *
		 * @return void
		 */
		public function run(){
			Schema::disableForeignKeyConstraints();
			$faker = Factory::create();
			EventDate::truncate();

			$res = Event::select('id')->get();
			foreach($res as $event){
				EventDate::create([
					'event' => $event->id,
					'location' => Location::inRandomOrder()->limit(1)->get()->first()->id,
					'title' => $faker->text(40),
					'short_description' => $faker->realText(),
					'description' => $faker->realText(),
					'street' => $faker->streetName,
					'street_nr' => $faker->randomNumber(),
					'address_supplement' => '',
					'date' => $faker->date(),
					'start' => $faker->time(),
					'end' => $faker->time(),
					'whole_day' => $faker->boolean? 1 : 0,
				]);
			}

			Schema::enableForeignKeyConstraints();
		}
	}
