<?php

	use Illuminate\Database\Migrations\Migration;
	use Illuminate\Database\Schema\Blueprint;
	use Illuminate\Support\Facades\Schema;

	class FallbackImage extends Migration{
		/**
		 * Run the migrations.
		 *
		 * @return void
		 */
		public function up(){
			Schema::table('event_kinds', function(Blueprint $table){
				$table->foreignId('fallback_image')->nullable()->after('description');

				$table->foreign('fallback_image')->references('id')->on('media');
			});
		}

		/**
		 * Reverse the migrations.
		 *
		 * @return void
		 */
		public function down(){
			Schema::table('event_kinds', function(Blueprint $table){
				$table->dropForeign('event_kinds_fallback_image_foreign');
				$table->dropColumn('fallback_image');
			});
		}
	}
