<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class EventPictograms extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
		Schema::table('events', function(Blueprint $table){
			$table->boolean('sustainability')->default(0)->after('instagram');
			$table->boolean('accessible')->default(0)->after('sustainability');
			$table->boolean('family_friendly')->default(0)->after('accessible');
			$table->boolean('with_cost')->default(0)->after('family_friendly');
		});
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
		Schema::table('events', function(Blueprint $table){
			$table->dropColumn('sustainability');
			$table->dropColumn('accessible');
			$table->dropColumn('family_friendly');
			$table->dropColumn('with_cost');
		});
    }
}
