<?php

	use Illuminate\Database\Migrations\Migration;
	use Illuminate\Database\Schema\Blueprint;
	use Illuminate\Support\Facades\Schema;

	class Routes extends Migration{
		/**
		 * Run the migrations.
		 *
		 * @return void
		 */
		public function up(){
			Schema::create('routes', function(Blueprint $table){
				$table->id();
				$table->string('name', 255)->default('');
				$table->string('uri', 255)->index();
				$table->enum('method', ['GET', 'POST', 'PUT', 'DELETE'])->index();
				$table->timestamps();
				$table->softDeletes('deleted_at', 0);
			});
		}

		/**
		 * Reverse the migrations.
		 *
		 * @return void
		 */
		public function down(){
			Schema::dropIfExists('routes');
		}
	}
