<?php

	use Illuminate\Database\Migrations\Migration;
	use Illuminate\Database\Schema\Blueprint;
	use Illuminate\Support\Facades\Schema;

	class UserToGroups extends Migration{
		/**
		 * Run the migrations.
		 *
		 * @return void
		 */
		public function up(){
			Schema::table('api_users', function(Blueprint $table){
				$table->foreignId('group_id')->nullable()->index()->after('id');

				$table->foreign('group_id')->references('id')->on('user_groups');
			});
		}

		/**
		 * Reverse the migrations.
		 *
		 * @return void
		 */
		public function down(){
			Schema::table('api_users', function(Blueprint $table){
				$table->dropForeign('api_users_group_id_foreign');
				$table->dropColumn('group_id');
			});
		}
	}
