<?php

	use Illuminate\Database\Migrations\Migration;
	use Illuminate\Database\Schema\Blueprint;
	use Illuminate\Support\Facades\Schema;

	class Media extends Migration{
		/**
		 * Run the migrations.
		 *
		 * @return void
		 */
		public function up(){
			Schema::dropIfExists('mediable');
			Schema::dropIfExists('media');
			Schema::dropIfExists('medias');

			Schema::create('media', function(Blueprint $table){
				$table->id();
				$table->string('name', 255)->index();
				$table->string('file_name', 255)->index();
				$table->string('path', 255);
				$table->timestamps();
				$table->softDeletes('deleted_at', 0);
			});

			Schema::create('media_relations', function(Blueprint $table){
				$table->id();
				$table->foreignId('media_id')->index();
				$table->foreignId('foreign_id')->index();
				$table->string('model', 255)->index();
				$table->timestamps();
				$table->softDeletes('deleted_at', 0);
			});
		}

		/**
		 * Reverse the migrations.
		 *
		 * @return void
		 */
		public function down(){
			Schema::dropIfExists('media');
			Schema::dropIfExists('media_relations');
		}
	}
