<?php

	use Illuminate\Database\Migrations\Migration;
	use Illuminate\Database\Schema\Blueprint;
	use Illuminate\Support\Facades\Schema;

	class ConnectUserAndApi extends Migration{
		/**
		 * Run the migrations.
		 *
		 * @return void
		 */
		public function up(){
			Schema::table('users', function(Blueprint $table){
				$table->foreignId('api_user')->nullable()->index()->after('password');
				$table->foreign('api_user')->references('id')->on('api_users');
			});
		}

		/**
		 * Reverse the migrations.
		 *
		 * @return void
		 */
		public function down(){
			Schema::disableForeignKeyConstraints();
			Schema::table('users', function(Blueprint $table){
				$table->dropColumn('api_user');
			});
			Schema::enableForeignKeyConstraints();
		}
	}
