<?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    class CreateEventDatesTable extends Migration
    {
        /**
         * Run the migrations.
         *
         * @return void
         */
        public function up()
        {
            Schema::create('event_dates', function (Blueprint $table) {
                $table->id();
                $table->foreignId('event')->index();
                $table->foreignId('location')->index();
                $table->string('title')->nullable()->index();
                $table->longText('description')->nullable();
                $table->string('street',255);
                $table->string('street_nr', 255);
                $table->string('address_supplement', 255);
                $table->date('date')->index();
                $table->time('start');
                $table->time('end');
                $table->boolean('whole_day');


                $table->timestamps();
                $table->softDeletes('deleted_at', 0);

                //foreign ids
                $table->foreign('event')->references('id')->on('events');
                $table->foreign('location')->references('id')->on('events');

            });
        }

        /**
         * Reverse the migrations.
         *
         * @return void
         */
        public function down()
        {
            Schema::dropIfExists('event_dates');
        }
    }
