<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\DB;

class User extends Authenticatable
{
    use Notifiable;

	public static $filterable = [
		'name',
		'email',
	];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function getBackendMenu(int $routeGroup): \Illuminate\Http\Resources\Json\AnonymousResourceCollection{
		$menuEntries = DB::table('menus')
			->join('menu_route_groups', 'menus.id', '=', 'menu_route_groups.menu')
			->where('menu_route_groups.route_group', '=', $routeGroup);
		//sonderlösung:
		//Benutzer Kreisentwicklung braucht Reiter Veranstaltungsfreigaben nicht
		if($this->id === 17){
			$menuEntries->where('menus.id', '!=', 11);
		}

		$menuEntries = $menuEntries->orderBy('menus.position', 'asc')
			->get()->all();

		return \App\Http\Resources\Menu::collection($menuEntries);
	}
}
