<?php

	namespace App\Services\Validators;

	use App\Event;
	use App\User;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class UserChecker{

		const FIELDS = [
			'name' => 'Name fehlt',
			'email' => 'Email fehlt',
			'domain' => 'Backend URL fehlt',
		];

		protected $request;

		public function __construct(Request $request){
			$this->request = $request;
		}

		/**
		 * @param array $params
		 * @return array
		 */
		public function validate(array $params):array{
			$result = [];

			foreach(self::FIELDS as $key => $error){
				if(empty($params[$key])){
					$result[] = $error;
				}
			}

			if($this->request->currentApiUser->group_id === 1){
				if(empty($params['group_id'])){
					$result[] = 'Gruppe fehlt';
				}
			}
			return $result;
		}

		/**
		 * @param array $params
		 * @return array
		 */
		public function checkDoubleUser(array $params): array{
			$errors = [];
			$byName = User::where('name', '=', $params['name'])
				->get()
				->first();

			if($byName){
				$errors[] = 'Benuztername schon vergeben';
			}

			$byEmail = User::where('email', '=', $params['email'])
				->get()
				->first();

			if($byEmail){
				$errors[] = 'Email schon registriert';
			}

			return $errors;
		}
	}
