<?php

	namespace App\Services;

	use App\Event;
	use App\UserGroupAuthority;
	use Illuminate\Http\Request;
	use Illuminate\Support\Facades\DB;

	class ReleaseService{

		public function __construct(){

		}

		public function updateReleases(Event $event, array $releases){
			$this->remove($event);

			foreach($releases as $release){
				if(isset($release['released']) && $release['released']){
					DB::table('event_releases')
						->insert([
							'event' => $event->id,
							'user_group' => $release['id'],
							'released' => 1,
						]);
				}
			}
		}

		public function remove(Event $event){
			$creator = $event->created_by;

			$deletable_groups = array_unique(UserGroupAuthority::getAllSubs($creator, true));

			DB::table('event_releases')
				->whereIn('user_group', $deletable_groups)
				->where('event', '=', $event->id)
				->delete();
		}

	}
